(function() {
  //    FILE:EventCollection
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'Backbone', 'Backbone.LocalStorage', 'moment', 'models/contact/ContactModel', 'models/request/RequestModel'], function($, Backbone, LocalStorage, Moment, ContactModel, RequestModel) {
    var ContactCollection;
    return ContactCollection = (function() {
      class ContactCollection extends Backbone.Collection {
        initialize() {
          this.reqMdl = new RequestModel();
          if (window.localStorage.getItem('Contacts')) {
            return this.fetch();
          }
        }

        comparator(contact) {
          return contact.get('n');
        }

        get_contacts(usr) {
          var jsonReq, response, that, timeStamp, xmlReq;
          that = this;
          jsonReq = this.reqMdl.get('JGetContacts');
          timeStamp = usr.get('contactlist_updated_at');
          if (!timeStamp) {
            timeStamp = Moment().format('YYYY-MM-DD hh:mm:ss');
          }
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'cacheTimeStamp', timeStamp);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var cache, categories, cfields, contacts, j, jsonObj, lS, lSCFields, lSCategories, lSTitles, len, m, ref, ref1, ref2, ref3, titles;
            jsonObj = data;
            //CHECK IF CACHE IS UP TO DATE
            cache = ((ref = jsonObj.Result) != null ? ref.cacheIsUpToDate : void 0) != null;
            if (cache === true) {
              that.fetch({
                success: function(data, err) {
                  var lS;
                  lS = new LocalStorage('ContactNames');
                  lS.records = _.pluck(that.models[0].toJSON(), 'n');
                  return lS.save();
                }
              });
              return that.trigger('collectionFilled');
            } else {
              that.reset({
                silent: true
              });
              contacts = jsonObj.Result.C;
              categories = jsonObj.Result.Category;
              cfields = jsonObj.Result.CustomField;
              titles = jsonObj.Result.Title;
              if (((ref1 = jsonObj.Result) != null ? ref1.isError : void 0) === "0" || ((ref2 = jsonObj.Result) != null ? ref2.isError : void 0) === 0) {
                if (that.models.length > 0) {
                  ref3 = that.models;
                  for (j = 0, len = ref3.length; j < len; j++) {
                    m = ref3[j];
                    that.remove(m);
                  }
                  that.create(contacts, {
                    silent: true
                  });
                } else if (that.models.length === 0) {
                  that.create(contacts, {
                    silent: true
                  });
                }
                if (contacts) {
                  lS = new LocalStorage('ContactNames');
                  lS.records = _.pluck(contacts, 'n');
                  lS.save();
                }
                if (categories) {
                  lSCategories = new LocalStorage('CompanyCategories');
                  lSCategories.records = categories;
                  lSCategories.save();
                }
                if (titles) {
                  lSTitles = new LocalStorage('ContactTitles');
                  lSTitles.records = titles;
                  lSTitles.save();
                }
                if (cfields) {
                  lSCFields = new LocalStorage('ContactCFields');
                  lSCFields.records = [];
                  _.each(cfields, function(cf) {
                    return lSCFields.records.push(JSON.stringify(cf));
                  });
                  lSCFields.save();
                }
                that.trigger('collectionFilled');
                return usr.save({
                  'contactlist_updated_at': jsonObj.Result.timeStamp
                });
              } else {
                if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                  window.localStorage.clear();
                  return window.location.href = 'index.html';
                }
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
          return this;
        }

        get_companies(usr) {
          var jsonReq, response, that, xmlReq;
          that = this;
          jsonReq = this.reqMdl.get('JGetCompanies');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var companies, jsonObj, lS;
            jsonObj = data;
            lS = new LocalStorage('CompanyList');
            lS.records = [];
            companies = jsonObj.Result.C;
            if (!_.isArray(companies)) {
              companies = new Array(companies);
            }
            companies.sort(function(a, b) {
              if (a.name < b.name) {
                return -1;
              }
              if (b.name < a.name) {
                return 1;
              }
              return 0;
            });
            _.each(companies, function(cp) {
              return lS.records.push(JSON.stringify(cp));
            });
            lS.save();
            that.trigger('companies_filled');
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              return window.location.href = 'index.html';
            }
          });
          return this;
        }

        delete_contact(usr, contactID) {
          var jsonReq, response, that, xmlReq;
          that = this;
          jsonReq = this.reqMdl.get('JDeleteContact');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'contactID', contactID);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(jsonObj, textStatus, jqXHR) {
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html';
            }
            return that.trigger('contact_deleted');
          });
          return this;
        }

        findByNameOrCompany(subStringContact) {
          var col, lS, names, res;
          res = [];
          lS = new LocalStorage('ContactNames');
          names = _.filter(lS.records, function(n) {
            return (n != null ? n.toLowerCase().indexOf(subStringContact.toLowerCase()) : void 0) !== -1;
          });
          col = this.models[0].toJSON();
          _.each(col, function(contact) {
            var ref;
            if (_.contains(names, contact.n) || ((ref = contact.c) != null ? ref.toLowerCase().indexOf(subStringContact.toLowerCase()) : void 0) !== -1) {
              return res.push(contact);
            }
          });
          return res;
        }

        getRange(N) {
          var col, i, maxLength, res;
          res = [];
          i = 0;
          //# DIRTY HACK TO CHECK IF IT"S ONLY ONE CONTACT OR MORE
          if (!('i' in this.models[0].attributes)) {
            col = _.toArray(this.models[0].attributes);
            maxLength = col.length > N ? N : col.length;
            while (i < maxLength) {
              res.push(col[i]);
              i++;
            }
          } else {
            res.push(this.models[0].attributes);
          }
          return res;
        }

      };

      ContactCollection.prototype.model = ContactModel;

      ContactCollection.prototype.localStorage = new LocalStorage('Contacts');

      return ContactCollection;

    }).call(this);
  });

}).call(this);
